/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.kubejs.utils;

import dev.architectury.hooks.fluid.forge.FluidStackHooksForge;
import dev.latvian.mods.kubejs.fluid.FluidStackJS;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.compat.kubejs.utils.Material;
import thelm.jaopca.compat.kubejs.utils.MaterialForm;
import thelm.jaopca.compat.kubejs.utils.Module;
import thelm.jaopca.utils.MiscHelper;

public class Form {
    private static final TreeMap<IForm, Form> FORM_WRAPPERS = new TreeMap();
    private final IForm form;

    public static Form getFormWrapper(IForm form) {
        return FORM_WRAPPERS.computeIfAbsent(form, Form::new);
    }

    private Form(IForm form) {
        this.form = form;
    }

    public IForm getInternal() {
        return this.form;
    }

    public String getName() {
        return this.form.getName();
    }

    public String getType() {
        return this.form.getType().getName();
    }

    public Module getModule() {
        return Module.getModuleWrapper(this.form.getModule());
    }

    public String getSecondaryName() {
        return this.form.getSecondaryName();
    }

    public List<String> getMaterialTypes() {
        return this.form.getMaterialTypes().stream().map(MaterialType::getName).collect(Collectors.toList());
    }

    public List<Material> getMaterials() {
        return this.form.getMaterials().stream().map(Material::getMaterialWrapper).collect(Collectors.toList());
    }

    public String getTagSeparator() {
        return this.form.getTagSeparator();
    }

    public boolean containsMaterial(Material material) {
        return this.form.getMaterials().contains(material.getInternal());
    }

    public String getTag(String suffix) {
        return MiscHelper.INSTANCE.getTagLocation(this.form.getSecondaryName(), suffix, this.form.getTagSeparator()).toString();
    }

    public ItemStackJS getItemStack(String suffix, int count) {
        MiscHelper helper = MiscHelper.INSTANCE;
        ItemStack stack = helper.getItemStack(helper.getTagLocation(this.form.getSecondaryName(), suffix), count);
        return ItemStackJS.of((Object)stack);
    }

    public ItemStackJS getItemStack(String suffix) {
        return this.getItemStack(suffix, 1);
    }

    public FluidStackJS getFluidStack(String suffix, int count) {
        MiscHelper helper = MiscHelper.INSTANCE;
        FluidStack stack = helper.getFluidStack(helper.getTagLocation(this.form.getSecondaryName(), suffix), count);
        return FluidStackJS.of((Object)FluidStackHooksForge.fromForge((FluidStack)stack));
    }

    public MaterialForm getMaterialForm(Material material) {
        if (!this.containsMaterial(material)) {
            return null;
        }
        return MaterialForm.getMaterialFormWrapper(this.form, material.getInternal());
    }

    public List<MaterialForm> getMaterialForms() {
        return this.form.getMaterials().stream().map(m -> MaterialForm.getMaterialFormWrapper(this.form, m)).collect(Collectors.toList());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Form)) {
            return false;
        }
        Form other = (Form)obj;
        return this.form == other.form;
    }

    public int hashCode() {
        return this.form.hashCode() + 5;
    }
}

